<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sale extends Model 
{

    protected $table = 'sales';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'costumer_id', 'subtotal', 'taxes', 'total');
    protected $visible = array('product_id', 'costumer_id', 'subtotal', 'taxes', 'total');

    public function products()
    {
        return $this->belongsToMany('App\Entities\Product')->withPrivot('products_sales');
    }

}